
async function getActiveTab(){
  const [tab] = await chrome.tabs.query({active:true, currentWindow:true});
  return tab;
}
function isSupportedUrl(url){
  try{
    const u = new URL(url);
    return ["http:", "https:", "file:"].includes(u.protocol);
  }catch(e){ return false; }
}

document.getElementById("btnToggle").addEventListener("click", async () => {
  const statusEl = document.getElementById("status");
  try{
    const tab = await getActiveTab();
    if (!tab || !isSupportedUrl(tab.url)){
      statusEl.textContent = "Trang đặc biệt (chrome://, Web Store, ...). Hãy mở một trang web http/https.";
      return;
    }
    // try toggle if content alive
    try{
      await chrome.tabs.sendMessage(tab.id, {type:"ccp_toggle_panel"});
      statusEl.textContent = "Đã chuyển trạng thái bảng điều khiển.";
      return;
    }catch(_){}

    // inject when not ready
    await chrome.scripting.executeScript({target:{tabId:tab.id}, files:["content.js"]});
    await chrome.tabs.sendMessage(tab.id, {type:"ccp_toggle_panel"});
    statusEl.textContent = "Đã bật bảng điều khiển.";
  }catch(e){
    statusEl.textContent = "Lỗi: " + (e.message||e);
  }
});
document.getElementById("btnOptions").addEventListener("click", () => chrome.runtime.openOptionsPage());
